public class boboStack 
{
   // data members
   protected boboChainNode topNode;
   protected int size;

   // constructors
   /** create an empty stack */
   public boboStack(int initialCapacity)
   {
       // the default initial value of topNode is null
	   size = 0;
   }

   public boboStack()
   {
      this(0);
	  size = 0;
   }

   public int size() 
   {
	   return size;
   }
   
   // methods
   /** @return true iff stack is empty */
   public boolean isEmpty()
   {
       return topNode == null;
   }


   /** @return top element of stack */
   public int peek()
   {
      if (isEmpty())
         throw new IllegalArgumentException
            ("boboStack.peek: stack is empty");
      return topNode.element;
   }

   /** add theElement to the top of the stack */
   public void push(int theElement)
   {
      topNode = new boboChainNode(theElement, topNode);
	  size++;
   }

   /** remove top element of stack and return it */
   public int pop()
   {
      if (isEmpty())
         throw new IllegalArgumentException
            ("boboStack.pop: stack is empty");
      int topElement = topNode.element;
      topNode = topNode.next;
	  size--;
      return topElement;
   }
}// end boboStack